import time
from tqdm import tqdm
import json
import jsonlines
import numpy as np
from fuzzywuzzy import fuzz
import spacy


if __name__ == "__main__":
    dataset = jsonlines.open('./gpt4_ans/winoground/anscom/text/test.jsonl', mode='r') 
    true_rate = 0.0
    false_rate = 0.0
    equal_rate = 0.0
    count = 0
    with tqdm(desc='Process', unit='it', total=41) as pbar: 
        for line in dataset.iter():
            chatgpt = line["gpt4_rate"]
            if 'true' in chatgpt.lower():
                true_rate += 1
            elif 'false' in chatgpt.lower():
                false_rate +=1
            else:
                equal_rate +=1
            pbar.set_postfix(true_rate=true_rate / (count + 1), false_rate=false_rate / (count + 1), equal_rate=equal_rate / (count + 1))
            count = count + 1
            pbar.update()